/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class BucketWheelBlockEntity
extends MultiblockPartBlockEntity<BucketWheelBlockEntity>
implements IEBlockInterfaces.IBlockBounds,
IEClientTickableBE {
    public float rotation = 0.0f;
    public final NonNullList<ItemStack> digStacks = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    public boolean active = false;
    private AABB renderAABB;
    private static final CachedShapesWithTransform<BlockPos, Direction> SHAPES = CachedShapesWithTransform.createDirectional(BucketWheelBlockEntity::getBoxes);

    public BucketWheelBlockEntity(BlockEntityType<BucketWheelBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.BUCKET_WHEEL, type, false, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        float nbtRot = nbt.m_128457_("rotation");
        this.rotation = (double)Math.abs(nbtRot - this.rotation) > 5.0 * (Double)IEServerConfig.MACHINES.excavator_speed.get() ? nbtRot : this.rotation;
        ContainerHelper.m_18980_((CompoundTag)nbt, this.digStacks);
        this.active = nbt.m_128471_("active");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128350_("rotation", this.rotation);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.digStacks);
        nbt.m_128379_("active", this.active);
    }

    @Override
    public void tickClient() {
        if (this.active) {
            this.rotation = (float)((double)this.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get());
            this.rotation %= 360.0f;
        }
    }

    @Override
    public void tickServer() {
        this.tickClient();
        if (this.active && this.f_58857_.m_46467_() % 20L == 0L) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("rotation", this.rotation);
            MessageBlockEntitySync sync = new MessageBlockEntitySync(this, nbt);
            ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)sync);
        }
    }

    public void spawnParticles(ItemStack stack) {
        Level w = this.getLevelNonnull();
        if (w instanceof ServerLevel && ((Boolean)IEServerConfig.MACHINES.excavator_particles.get()).booleanValue()) {
            Direction facing = this.getFacing();
            Direction.Axis axis = facing.m_122434_();
            int sign = this.getIsMirrored() ^ facing.m_122421_() == Direction.AxisDirection.NEGATIVE ? 1 : -1;
            double x = (double)this.m_58899_().m_123341_() + 0.5;
            double y = (double)this.m_58899_().m_123342_() + 2.5;
            double z = (double)this.m_58899_().m_123343_() + 0.5;
            double fixPosOffset = 0.5 * (double)sign;
            double fixVelOffset = 0.075 * (double)sign;
            for (int i = 0; i < 16; ++i) {
                double mX = (this.getLevelNonnull().f_46441_.nextDouble() - 0.5) * 0.01;
                double mY = this.getLevelNonnull().f_46441_.nextDouble() * -0.05;
                double mZ = (this.getLevelNonnull().f_46441_.nextDouble() - 0.5) * 0.01;
                double rndPosOffset = 0.2 * (this.getLevelNonnull().f_46441_.nextDouble() - 0.5);
                if (facing.m_122434_() == Direction.Axis.X) {
                    mX += fixVelOffset;
                } else {
                    mZ += fixVelOffset;
                }
                ((ServerLevel)w).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x + axis.m_6150_(fixPosOffset, 0.0, rndPosOffset), y, z + axis.m_6150_(rndPosOffset, 0.0, fixPosOffset), 0, mX, mY, mZ, 1.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        NonNullList<ItemStack> nonNullList = this.digStacks;
        synchronized (nonNullList) {
            int packetRotation;
            if (message.m_128425_("fill", 3)) {
                this.digStacks.set(message.m_128451_("fill"), (Object)ItemStack.m_41712_((CompoundTag)message.m_128469_("fillStack")));
            }
            if (message.m_128425_("empty", 3)) {
                int toRemove = message.m_128451_("empty");
                this.digStacks.set(toRemove, (Object)ItemStack.f_41583_);
            }
            if (message.m_128425_("rotation", 3) && (double)Math.abs((float)(packetRotation = message.m_128451_("rotation")) - this.rotation) > 5.0 * (Double)IEServerConfig.MACHINES.excavator_speed.get()) {
                this.rotation = packetRotation;
            }
        }
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AABB(this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0), -3, -(this.getFacing().m_122434_() == Direction.Axis.X ? 3 : 0)), this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 4 : 1, 4, this.getFacing().m_122434_() == Direction.Axis.X ? 4 : 1));
        }
        return this.renderAABB;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.posInMultiblock, this.getFacing());
    }

    private static List<AABB> getBoxes(BlockPos posInMultiblock) {
        AABB ret = ImmutableSet.of((Object)new BlockPos(3, 0, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(4, 1, 0)).contains((Object)posInMultiblock) ? new AABB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(3, 6, 0), (Object)new BlockPos(2, 5, 0), (Object)new BlockPos(4, 5, 0)).contains((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0) : (new BlockPos(0, 3, 0).equals((Object)posInMultiblock) ? new AABB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0) : (new BlockPos(6, 3, 0).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(1, 2, 0), (Object)new BlockPos(1, 4, 0)).contains((Object)posInMultiblock) ? new AABB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(5, 2, 0), (Object)new BlockPos(5, 4, 0)).contains((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0) : new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))))));
        return ImmutableList.of((Object)ret);
    }

    public void adjustStructureFacingAndMirrored(Direction targetFacing, boolean targetMirrored) {
        if (this == this.master() && targetFacing.m_122434_() != Direction.Axis.Y && (this.getFacing() != targetFacing || this.getIsMirrored() != targetMirrored)) {
            boolean changePos = this.getFacing() != targetFacing ^ (this.getIsMirrored() ^ targetMirrored);
            for (int h = -3; h <= 3; ++h) {
                for (int w = -3; w <= 3; ++w) {
                    BlockEntity te;
                    if (Math.abs(h) == 3 && w != 0 || Math.abs(w) == 3 && h != 0 || !((te = this.f_58857_.m_7702_(this.m_58899_().m_142082_(0, h, 0).m_5484_(this.getFacing(), w))) instanceof BucketWheelBlockEntity)) continue;
                    BucketWheelBlockEntity bucketTE = (BucketWheelBlockEntity)te;
                    bucketTE.setFacing(targetFacing);
                    bucketTE.setMirrored(targetMirrored);
                    if (changePos) {
                        bucketTE.posInMultiblock = new BlockPos(6 - bucketTE.posInMultiblock.m_123341_(), bucketTE.posInMultiblock.m_123342_(), bucketTE.posInMultiblock.m_123343_());
                    }
                    te.m_6596_();
                    bucketTE.markContainingBlockForUpdate(null);
                    this.f_58857_.m_7696_(te.m_58899_(), te.m_58900_().m_60734_(), 255, 0);
                }
            }
        }
    }
}

